;Written by Iain McCurdy, 2006


; Modified for QuteCsound by René, November 2010
; Tested on Ubuntu 10.04 with csound-double cvs August 2010 and QuteCsound svn rev 733

;Notes on modifications from original csd:
;	Cannot display more than one space in Label, so can't display the schematic shown below:

	;  SIMPLIFIED SCHEMATIC FOR A MODULATOR AND CARRIER FM PAIR
	;----------------------------------------------------------
	;
	;                         +-----------+
	;                         |   oscil   |
	;                         |(modulator)|
	;                         +-----+-----+
	;                               |
	;                               |
	;                               |
	;                               |
	;                               |
	;                         +-----------+
	;                         |   oscil   |
	;                         | (carrier) |
	;                         +-----+-----+
	;                               |
	;                               |
	;                              OUT


;my flags on Ubuntu: -iadc -odac -b1024 -B2048 -+rtaudio=alsa -+rtmidi=null -m0
<CsoundSynthesizer>
<CsOptions>

</CsOptions>
<CsInstruments>
sr 		= 44100	;SAMPLE RATE
ksmps 	= 1		;NUMBER OF AUDIO SAMPLES IN EACH CONTROL CYCLE
nchnls	= 2		;NUMBER OF CHANNELS (2=STEREO)


gisine	ftgen 0, 0, 129, 10, 1	;A SINE WAVE (INTERPOLATING OSCILLATOR OPCODES ARE USED THEREFORE A SMALL TABLE SIZE (+1) CAN BE USED)


instr	1	;GUI
	ktrig	metro	10
	if (ktrig == 1)	then
		gkModAmp		invalue 	"Modulator_Amplitude"
		gkCarrAmp		invalue 	"Carrier_Amplitude"

		gkModFreq		invalue	"Modulator_Frequency"
		gkCarrFreq	invalue	"Carrier_Frequency"
	endif
endin

instr	2
	kporttime		linseg	0,0.001,0.005,1,0.005								;CREATE A VARIABLE FUNCTION THAT RAPIDLY RAMPS UP TO A SET VALUE
	kModAmp		portk	gkModAmp, kporttime									;SMOOTH SLIDER VARIABLE
	aModAmp		interp	kModAmp											;INTERPOLATE AND CREATE AN AUDIO RATE VERSION OF K-RATE VARIABLE

	;OUTPUT		OPCODE	AMPLITUDE |FREQUENCY            |FUNCTION_TABLE	
	aModulator	oscili	aModAmp,   gkModFreq,             gisine				;DEFINE THE MODULATOR WAVEFORM
	aCarrier		oscili	gkCarrAmp, gkCarrFreq+aModulator, gisine				;DEFINE THE CARRIER WAVEFORM (NOTE HOW ITS FREQUENCY IS MODULATED (THROUGH ADDITION) BY THE AUDIO OUTPUT OF THE MODULATOR WAVEFORM)
				outs		aCarrier, aCarrier									;SEND THE AUDIO OUTPUT OF THE CARRIER WAVEFORM *ONLY* TO THE OUTPUTS 
				dispfft aCarrier * 2, 0.1, 2048
endin
</CsInstruments>
<CsScore>
;INSTR | START | DURATION
i 1		0	   3600		;GUI
</CsScore>
</CsoundSynthesizer>

<bsbPanel>
 <label>Widgets</label>
 <objectName/>
 <x>145</x>
 <y>139</y>
 <width>1032</width>
 <height>570</height>
 <visible>true</visible>
 <uuid/>
 <bgcolor mode="background">
  <r>241</r>
  <g>226</g>
  <b>185</b>
 </bgcolor>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>2</x>
  <y>2</y>
  <width>514</width>
  <height>566</height>
  <uuid>{aa607456-d368-4d59-8497-d16d608404c3}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>             FM Synthesis: Simple Modulator->Carrier</label>
  <alignment>center</alignment>
  <font>Liberation Sans</font>
  <fontsize>18</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="background">
   <r>5</r>
   <g>27</g>
   <b>150</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>5</borderradius>
  <borderwidth>2</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>515</x>
  <y>2</y>
  <width>517</width>
  <height>568</height>
  <uuid>{74928ed2-b701-4668-9a11-74763d317e9b}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>FM Synthesis: Simple Modulator->Carrier</label>
  <alignment>center</alignment>
  <font>Arial Black</font>
  <fontsize>18</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="background">
   <r>5</r>
   <g>27</g>
   <b>150</b>
  </bgcolor>
  <bordermode>border</bordermode>
  <borderradius>5</borderradius>
  <borderwidth>2</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>519</x>
  <y>20</y>
  <width>510</width>
  <height>547</height>
  <uuid>{d4bdb5ce-87d8-4c8c-9c64-40ec2eed6f5a}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>----------------------------------------------------------------------------------------------------------------------------
This example demonstrates FM (frequency modulation) synthesis in its simplest form. Two oscillators are used (one will be referred to as the 'carrier' and the other as the 'modulator'). Both oscillators employ a sine wave shape (as is most often the case in FM synthesis). The frequency (pitch) of the carrier is modulated (through addition) by the audio output of the modulator. Only the audio output of the carrier will be present at the final audio outputs of the FM synthesis algorithm. (The modulator is heard indirectly through its influence upon the frequency of the carrier.) In this example the user is given direct control over the amplitudes and frequencies of the modulator and carrier oscillators. This is probably not the most useful design for FM synthesis but should provide a clearer idea of how the modulator and carrier interact. First of all adjust the carrier amplitude. Notice how this functions as a simple volume control. It has no effect on timbre. Next adjust the modulator amplitude. Notice how this varies the brightness or spectral intensity of the sound. When this is set at zero we are left with a pure sine tone (not silence!). When we vary the modulator and carrier frequencies this changes the nature of the timbre. (These parameters are adjusted by either clicking and dragging left and right on the values displayed or by clicking a cursor into the box and typing in a new value.) Notice how when the modulator and carrier frequencies are in simple ratio with one another harmonic spectra are produced. For example when M.F. (modulator frequency) is 300 Hz and when C.F. (carrier frequency) is 200. Notice how when M.F. and C.F. are not in simple ratio with one another inharmonic spectra are produced. For example when M.F. is 277 and C.F. is 200. Notice how when one frequency is slowly detuned away from a simple ratio with respect to the other a kind of timbral 'beating' is heard. As the amount of detuning increases the rate of beating increases until it is no longer perceivable. In general the modulator amplitude should be quite low in order to produce more interesting timbres that are not excessively shrill. As M.F. and C.F. are lowered the modulator amplitude should be also be lowered to maintain a constant spectral intensity. This is why in conventionally implemented FM synthesis a new parameter called 'the index of modulation' is derived that is directly proportional to the peak deviation (amplitude) of the modulator and inversely proportional to carrier modulator frequency. The next example makes use of the 'index of modulation' formula.</label>
  <alignment>left</alignment>
  <font>Arial</font>
  <fontsize>14</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBButton">
  <objectName/>
  <x>8</x>
  <y>6</y>
  <width>100</width>
  <height>30</height>
  <uuid>{24979132-c53f-4414-ac6b-6b4f503ecfe8}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <type>event</type>
  <pressedValue>1.00000000</pressedValue>
  <stringvalue/>
  <text>  ON / OFF</text>
  <image>/</image>
  <eventLine>i 2 0 -1</eventLine>
  <latch>true</latch>
  <latched>false</latched>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Modulator_Amplitude</objectName>
  <x>448</x>
  <y>63</y>
  <width>60</width>
  <height>30</height>
  <uuid>{745d6bee-b951-4a03-9fe8-9e10d5ae4556}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>668.000</label>
  <alignment>right</alignment>
  <font>Arial</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBHSlider">
  <objectName>Modulator_Amplitude</objectName>
  <x>8</x>
  <y>46</y>
  <width>500</width>
  <height>27</height>
  <uuid>{06814721-6151-4baa-84e2-8f39843b07a4}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>2000.00000000</maximum>
  <value>668.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>8</x>
  <y>63</y>
  <width>180</width>
  <height>30</height>
  <uuid>{c6d7165c-6730-426f-b293-52b411bc73cf}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Modulator Amplitude</label>
  <alignment>left</alignment>
  <font>Arial</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>8</x>
  <y>101</y>
  <width>160</width>
  <height>30</height>
  <uuid>{f9f4369b-a39e-45aa-ba99-7457a534535f}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Carrier Amplitude</label>
  <alignment>left</alignment>
  <font>Arial</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBHSlider">
  <objectName>Carrier_Amplitude</objectName>
  <x>8</x>
  <y>84</y>
  <width>500</width>
  <height>27</height>
  <uuid>{42fe25e5-e98f-4f00-872c-f791822a1b3e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <minimum>0.00000000</minimum>
  <maximum>10000.00000000</maximum>
  <value>3360.00000000</value>
  <mode>lin</mode>
  <mouseControl act="jump">continuous</mouseControl>
  <resolution>-1.00000000</resolution>
  <randomizable group="0">false</randomizable>
 </bsbObject>
 <bsbObject version="2" type="BSBDisplay">
  <objectName>Carrier_Amplitude</objectName>
  <x>448</x>
  <y>101</y>
  <width>60</width>
  <height>30</height>
  <uuid>{a8f35453-f236-447d-88d9-1a0b135383b6}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>3360.000</label>
  <alignment>right</alignment>
  <font>Arial</font>
  <fontsize>9</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>47</x>
  <y>187</y>
  <width>150</width>
  <height>30</height>
  <uuid>{03adbcba-e8ca-4c98-9109-2ac9886e0a8e}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Carrier Frequency</label>
  <alignment>right</alignment>
  <font>Arial</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBLabel">
  <objectName/>
  <x>47</x>
  <y>149</y>
  <width>150</width>
  <height>30</height>
  <uuid>{f8a79186-e423-4ebd-a512-4913282530b6}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <label>Modulator Frequency</label>
  <alignment>right</alignment>
  <font>Arial</font>
  <fontsize>10</fontsize>
  <precision>3</precision>
  <color>
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <bordermode>noborder</bordermode>
  <borderradius>1</borderradius>
  <borderwidth>1</borderwidth>
 </bsbObject>
 <bsbObject version="2" type="BSBSpinBox">
  <objectName>Modulator_Frequency</objectName>
  <x>198</x>
  <y>150</y>
  <width>70</width>
  <height>28</height>
  <uuid>{4a5191df-8241-43b7-a5ea-179231af25a4}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <alignment>left</alignment>
  <font>Liberation Sans</font>
  <fontsize>14</fontsize>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <resolution>0.50000000</resolution>
  <minimum>0</minimum>
  <maximum>20000</maximum>
  <randomizable group="0">false</randomizable>
  <value>200</value>
 </bsbObject>
 <bsbObject version="2" type="BSBSpinBox">
  <objectName>Carrier_Frequency</objectName>
  <x>198</x>
  <y>188</y>
  <width>70</width>
  <height>28</height>
  <uuid>{20d8a2f6-4a04-4050-8317-8e56207e9fe5}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <alignment>left</alignment>
  <font>Arial</font>
  <fontsize>14</fontsize>
  <color>
   <r>0</r>
   <g>0</g>
   <b>0</b>
  </color>
  <bgcolor mode="nobackground">
   <r>255</r>
   <g>255</g>
   <b>255</b>
  </bgcolor>
  <resolution>0.50000000</resolution>
  <minimum>0</minimum>
  <maximum>20000</maximum>
  <randomizable group="0">false</randomizable>
  <value>200</value>
 </bsbObject>
 <bsbObject version="2" type="BSBScope">
  <objectName/>
  <x>9</x>
  <y>224</y>
  <width>501</width>
  <height>164</height>
  <uuid>{221c0462-6fc0-482d-ba46-cf43d3b19d9c}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>-3</midicc>
  <value>-255.00000000</value>
  <type>scope</type>
  <zoomx>2.00000000</zoomx>
  <zoomy>1.00000000</zoomy>
  <dispx>1.00000000</dispx>
  <dispy>1.00000000</dispy>
  <mode>0.00000000</mode>
 </bsbObject>
 <bsbObject version="2" type="BSBGraph">
  <objectName/>
  <x>10</x>
  <y>391</y>
  <width>500</width>
  <height>172</height>
  <uuid>{2139f04b-aa23-4fd9-9a75-051daddbcb58}</uuid>
  <visible>true</visible>
  <midichan>0</midichan>
  <midicc>0</midicc>
  <value>1</value>
  <objectName2/>
  <zoomx>3.00000000</zoomx>
  <zoomy>1.00000000</zoomy>
  <dispx>1.00000000</dispx>
  <dispy>1.00000000</dispy>
  <modex>lin</modex>
  <modey>lin</modey>
  <all>true</all>
 </bsbObject>
</bsbPanel>
<bsbPresets>
</bsbPresets>
<MacOptions>
Version: 3
Render: Real
Ask: Yes
Functions: ioObject
Listing: Window
WindowBounds: 72 179 400 200
CurrentView: io
IOViewEdit: On
Options:
</MacOptions>

<MacGUI>
ioView background {61937, 58082, 47545}
ioText {2, 2} {512, 260} label 0.000000 0.00100 "" center "Liberation Sans" 18 {65280, 65280, 65280} {1280, 6912, 38400} nobackground noborder              FM Synthesis: Simple Modulator->Carrier
ioText {515, 2} {517, 568} label 0.000000 0.00100 "" center "Arial Black" 18 {65280, 65280, 65280} {1280, 6912, 38400} nobackground noborder FM Synthesis: Simple Modulator->Carrier
ioText {519, 20} {510, 547} label 0.000000 0.00100 "" left "Arial" 14 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder ----------------------------------------------------------------------------------------------------------------------------Â¬This example demonstrates FM (frequency modulation) synthesis in its simplest form. Two oscillators are used (one will be referred to as the 'carrier' and the other as the 'modulator'). Both oscillators employ a sine wave shape (as is most often the case in FM synthesis). The frequency (pitch) of the carrier is modulated (through addition) by the audio output of the modulator. Only the audio output of the carrier will be present at the final audio outputs of the FM synthesis algorithm. (The modulator is heard indirectly through its influence upon the frequency of the carrier.) In this example the user is given direct control over the amplitudes and frequencies of the modulator and carrier oscillators. This is probably not the most useful design for FM synthesis but should provide a clearer idea of how the modulator and carrier interact. First of all adjust the carrier amplitude. Notice how this functions as a simple volume control. It has no effect on timbre. Next adjust the modulator amplitude. Notice how this varies the brightness or spectral intensity of the sound. When this is set at zero we are left with a pure sine tone (not silence!). When we vary the modulator and carrier frequencies this changes the nature of the timbre. (These parameters are adjusted by either clicking and dragging left and right on the values displayed or by clicking a cursor into the box and typing in a new value.) Notice how when the modulator and carrier frequencies are in simple ratio with one another harmonic spectra are produced. For example when M.F. (modulator frequency) is 300 Hz and when C.F. (carrier frequency) is 200. Notice how when M.F. and C.F. are not in simple ratio with one another inharmonic spectra are produced. For example when M.F. is 277 and C.F. is 200. Notice how when one frequency is slowly detuned away from a simple ratio with respect to the other a kind of timbral 'beating' is heard. As the amount of detuning increases the rate of beating increases until it is no longer perceivable. In general the modulator amplitude should be quite low in order to produce more interesting timbres that are not excessively shrill. As M.F. and C.F. are lowered the modulator amplitude should be also be lowered to maintain a constant spectral intensity. This is why in conventionally implemented FM synthesis a new parameter called 'the index of modulation' is derived that is directly proportional to the peak deviation (amplitude) of the modulator and inversely proportional to carrier modulator frequency. The next example makes use of the 'index of modulation' formula.
ioButton {8, 6} {100, 30} event 1.000000 "" "  ON / OFF" "/" i 2 0 -1
ioText {448, 63} {60, 30} display 668.000000 0.00100 "Modulator_Amplitude" right "Arial" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 668.000
ioSlider {8, 46} {500, 27} 0.000000 2000.000000 668.000000 Modulator_Amplitude
ioText {8, 63} {180, 30} label 0.000000 0.00100 "" left "Arial" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Modulator Amplitude
ioText {8, 101} {160, 30} label 0.000000 0.00100 "" left "Arial" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Carrier Amplitude
ioSlider {8, 84} {500, 27} 0.000000 10000.000000 3360.000000 Carrier_Amplitude
ioText {448, 101} {60, 30} display 3360.000000 0.00100 "Carrier_Amplitude" right "Arial" 9 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder 3360.000
ioText {47, 187} {150, 30} label 0.000000 0.00100 "" right "Arial" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Carrier Frequency
ioText {47, 149} {150, 30} label 0.000000 0.00100 "" right "Arial" 10 {65280, 65280, 65280} {63232, 62720, 61952} nobackground noborder Modulator Frequency
ioText {198, 150} {70, 28} editnum 200.000000 0.500000 "Modulator_Frequency" left "" 0 {0, 0, 0} {63232, 62720, 61952} nobackground noborder 200.000000
ioText {198, 188} {70, 28} editnum 200.000000 0.500000 "Carrier_Frequency" left "" 0 {0, 0, 0} {63232, 62720, 61952} nobackground noborder 200.000000
ioGraph {9, 224} {501, 164} scope 2.000000 -255 
ioGraph {10, 391} {500, 172} table 1.000000 3.000000 
</MacGUI>
<EventPanel name="" tempo="60.00000000" loop="8.00000000" x="913" y="162" width="655" height="346" visible="true" loopStart="0" loopEnd="0">    </EventPanel>
